/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.FlyOverPanel;
import ibm.nways.nhm.eui.NhmCheckbox;
import ibm.nways.nhm.eui.NhmEventViewImpl;
import ibm.nways.nhm.eui.NhmHelpRef;
import ibm.nways.nhm.eui.NhmReportEditor;
import ibm.nways.nhm.eui.NhmResourceManager;
import ibm.nways.nhm.eui.NhmView;
import ibm.nways.nhm.eui.NhmViewNotebook;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.net.URL;
import java.rmi.Naming;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCTabButton;
import jclass.util.JCEnvironment;

public class NhmPanel
extends Panel
implements JCItemListener,
ItemListener,
ActionListener {
    private NhmViewNotebook notebook;
    private Panel buttons;
    private Button next;
    private Button previous;
    private Panel mainPanel;
    private Panel toolbarPanel;
    private ScrollPane toolbarScrollPane;
    protected Applet applet;
    private String hostname;
    private String groupName;
    private String serverHost;
    private int portNum;
    private Date startDate;
    private Date endDate;
    private DateFormat df = DateFormat.getDateTimeInstance(1, 1);
    private boolean chartButtonsDisabled;
    private static final int NUM_REPORT_ACTIONS = 2;
    private static final int NUM_HISTORY_GRAPH_TYPES = 3;
    private static final int NUM_POINT_GRAPH_TYPES = 2;
    private static final int NUM_CONFIG_ACTIONS = 1;
    private static final int NUM_IMAGES = 8;
    private static String[] imageFiles = new String[]{"linegraph.gif", "stackedbar.gif", "stackedbar100.gif", "bargraph.gif", "piegraph.gif", "report.gif", "edit_report.gif", "help.gif"};
    private static final int GRAPH_LINE = 0;
    private static final int GRAPH_STACKED_BAR = 1;
    private static final int GRAPH_STACKED_BAR_100 = 2;
    private static final int GRAPH_BAR = 3;
    private static final int GRAPH_PIE = 4;
    private static final int REPORT_CONFIG = 5;
    private static final int REPORT_EDIT = 6;
    private static final int HELP_BUTTON = 7;
    private static Image[] images = null;
    private JCCheckbox[] imageButtons = new JCCheckbox[8];
    private Panel reportBar;
    protected NhmResourceManager resource;
    private NhmReportEditor reportEditor;
    private static DpmClientApplet dpmClient = null;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");
    private FlyOverPanel flyOver;
    private boolean flyOverActive = false;
    private int flyOverDelay = 1000;
    private FlyOverTimer flyOverTimer;

    public NhmPanel() {
    }

    public NhmPanel(Applet applet, String string, int n) {
        this.initializePanel(applet, string, n);
    }

    private int getFlyOverDelay() {
        return this.flyOverDelay;
    }

    public void initializePanel(Applet applet, String string, int n) {
        Serializable serializable;
        this.df.setTimeZone(TimeZone.getDefault());
        int n2 = 0;
        this.applet = applet;
        this.serverHost = string;
        this.portNum = n;
        this.flyOver = new FlyOverPanel();
        this.flyOver.setVisible(false);
        this.add(this.flyOver);
        this.setLayout(new BorderLayout());
        Class<?> clazz = this.getClass();
        if (images == null) {
            serializable = new MediaTracker(this);
            images = new Image[8];
            n2 = 0;
            while (n2 < 8) {
                try {
                    URL uRL = clazz.getResource(imageFiles[n2]);
                    NhmPanel.images[n2] = applet.getImage(uRL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((MediaTracker)serializable).addImage(images[n2], n2);
                ++n2;
            }
            try {
                ((MediaTracker)serializable).waitForAll();
            }
            catch (InterruptedException interruptedException) {
                Traces.logException(interruptedException);
            }
        }
        this.createToolbar();
        serializable = applet.getParent();
        while (!(serializable instanceof Frame)) {
            serializable = ((Component)serializable).getParent();
        }
        Frame frame = (Frame)serializable;
        this.reportEditor = new NhmReportEditor(frame, string, applet, n);
    }

    public void finalize() {
        this.unregisterForEvents();
    }

    public void unregisterForEvents() {
        if (this.notebook != null && dpmClient != null) {
            this.notebook.unregisterForEvents(dpmClient);
        }
    }

    public void setResource(Applet applet, String string, int n, NhmResourceManager nhmResourceManager) {
        this.initializePanel(applet, string, n);
        this.setResource(nhmResourceManager);
    }

    public void setResource(NhmResourceManager nhmResourceManager) {
        Object object;
        Vector vector = null;
        this.resource = nhmResourceManager;
        this.getParent();
        if (dpmClient == null) {
            try {
                object = "rmi://";
                object = ((String)object).concat(this.serverHost);
                object = ((String)object).concat(":");
                object = ((String)object).concat(String.valueOf(this.portNum));
                object = ((String)object).concat("/dpServer");
                dpmClient = (DpmClientApplet)Naming.lookup((String)object);
            }
            catch (Exception exception) {
                Traces.logException(exception);
            }
        }
        try {
            vector = dpmClient.getViewNames(nhmResourceManager.dpGetDeviceType(), nhmResourceManager.dpGetResourceType());
        }
        catch (Exception exception) {
            Traces.logException(exception);
        }
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(new BorderLayout());
        this.notebook = new NhmViewNotebook(dpmClient, nhmResourceManager, this.applet);
        if (JCEnvironment.getBrowser(this.applet) == 3) {
            this.buttons = new Panel();
            this.buttons.setForeground(Color.black);
            this.buttons.setLayout(new FlowLayout());
            this.previous = new Button(this.nhmRes.getString("s_Previous"));
            this.previous.setBackground(Color.lightGray);
            this.previous.addActionListener(this);
            this.next = new Button(this.nhmRes.getString("s_Next"));
            this.next.setBackground(Color.lightGray);
            this.next.addActionListener(this);
            this.buttons.add(this.previous);
            this.buttons.add(this.next);
            this.mainPanel.add("North", this.buttons);
        }
        this.mainPanel.add("Center", this.notebook);
        if (vector != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.notebook.addPage(string);
            }
            if (this.notebook != null) {
                this.add("Center", this.mainPanel);
                this.notebook.addItemListener(this);
                return;
            }
            Traces.logError(this, "notebook not created -- no view names returned by dpmClient: " + nhmResourceManager.dpGetHostname() + "," + nhmResourceManager.dpGetResourceType());
            return;
        }
        Traces.logError(this, "getViewNames returned null: " + nhmResourceManager.dpGetHostname() + "," + nhmResourceManager.dpGetResourceType());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.previous) {
            JCTabButton[] jCTabButtonArray = this.notebook.getTabs();
            int n = this.notebook.getFirstVisibleTab();
            if (n > 0) {
                this.notebook.setFirstVisibleTab(n - 1);
                return;
            }
            this.notebook.setFirstVisibleTab(jCTabButtonArray.length - 1);
            return;
        }
        if (actionEvent.getSource() == this.next) {
            JCTabButton[] jCTabButtonArray = this.notebook.getTabs();
            int n = this.notebook.getFirstVisibleTab();
            if (n < jCTabButtonArray.length - 1) {
                this.notebook.setFirstVisibleTab(n + 1);
                return;
            }
            this.notebook.setFirstVisibleTab(0);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = this.notebook.getSelectedObjects()[0];
        if (object instanceof NhmEventViewImpl) {
            this.imageButtons[0].setEnabled(false);
            this.imageButtons[1].setEnabled(false);
            this.imageButtons[2].setEnabled(false);
            this.imageButtons[3].setEnabled(false);
            this.imageButtons[4].setEnabled(false);
            this.imageButtons[5].setEnabled(false);
            this.chartButtonsDisabled = true;
            return;
        }
        if (this.chartButtonsDisabled) {
            this.imageButtons[0].setEnabled(true);
            this.imageButtons[1].setEnabled(true);
            this.imageButtons[2].setEnabled(true);
            this.imageButtons[3].setEnabled(true);
            this.imageButtons[4].setEnabled(true);
            this.imageButtons[5].setEnabled(true);
            this.chartButtonsDisabled = false;
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
        Integer n = (Integer)jCCheckbox.getUserData();
        Component component = null;
        switch (n) {
            case 5: {
                this.reportEditor.addCurrentView(this.notebook);
                return;
            }
            case 6: {
                this.reportEditor.editReport();
                return;
            }
            case 0: {
                component = this.notebook.getCurrentPage();
                if (!(component instanceof NhmView)) break;
                NhmView nhmView = (NhmView)component;
                nhmView.setCurrentChartType(0);
                return;
            }
            case 3: {
                component = this.notebook.getCurrentPage();
                if (!(component instanceof NhmView)) break;
                NhmView nhmView = (NhmView)component;
                nhmView.setCurrentChartType(9);
                return;
            }
            case 1: {
                component = this.notebook.getCurrentPage();
                if (!(component instanceof NhmView)) break;
                NhmView nhmView = (NhmView)component;
                nhmView.setCurrentChartType(10);
                return;
            }
            case 2: {
                component = this.notebook.getCurrentPage();
                if (!(component instanceof NhmView)) break;
                NhmView nhmView = (NhmView)component;
                nhmView.setCurrentChartType(-1);
                return;
            }
            case 4: {
                component = this.notebook.getCurrentPage();
                if (!(component instanceof NhmView)) break;
                NhmView nhmView = (NhmView)component;
                nhmView.setCurrentChartType(11);
                return;
            }
            case 7: {
                NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
                if (this.applet instanceof BrowserApplet) {
                    BrowserApplet browserApplet = (BrowserApplet)this.applet;
                    browserApplet.showHelp(nhmHelpRef);
                    return;
                }
                this.applet.getAppletContext().showDocument(nhmHelpRef.getURL(this.applet));
                return;
            }
        }
    }

    protected void createToolbar() {
        this.toolbarScrollPane = new ScrollPane();
        this.toolbarPanel = new Panel(new GridLayout(1, 0, 0, 0));
        int n = 0;
        Image[][] imageArray = new Image[8][1];
        n = 0;
        while (n < 8) {
            String string = null;
            string = this.nhmRes.getString("fo_" + String.valueOf(n));
            this.imageButtons[n] = new NhmCheckbox(this, string);
            this.imageButtons[n].setIndicator(5);
            imageArray[n][0] = images[n];
            this.imageButtons[n].setIndicatorImageList(imageArray[n]);
            this.imageButtons[n].setNumStates(1);
            this.imageButtons[n].addItemListener(this);
            this.imageButtons[n].setUserData(new Integer(n));
            this.toolbarPanel.add(this.imageButtons[n]);
            if (n <= 5) {
                this.imageButtons[n].setEnabled(false);
            }
            ++n;
        }
        this.chartButtonsDisabled = true;
        this.add("North", this.toolbarPanel);
    }

    private synchronized void showFlyOver(String string, Point point) {
        Point point2 = this.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        this.flyOver.initializeFlyOver(string, point3, this.getSize(), this.getGraphics());
        this.flyOver.setVisible(true);
    }

    public synchronized void hideFlyOver() {
        if (this.flyOverTimer != null && this.flyOverTimer.isAlive()) {
            this.flyOverTimer.stop();
        }
        this.flyOver.setVisible(false);
    }

    public synchronized void setButtonWithFlyOver(NhmCheckbox nhmCheckbox, Point point) {
        if (nhmCheckbox != null) {
            if (!nhmCheckbox.getFlyOverActive()) {
                if (this.flyOverTimer != null && this.flyOverTimer.isAlive()) {
                    this.flyOverTimer.stop();
                }
                this.flyOverTimer = new FlyOverTimer(nhmCheckbox, point);
                this.flyOverTimer.start();
                return;
            }
        } else {
            this.hideFlyOver();
        }
    }

    final /* synthetic */ int access$0() {
        return this.getFlyOverDelay();
    }

    final /* synthetic */ void access$1(String string, Point point) {
        this.showFlyOver(string, point);
    }

    class FlyOverTimer
    extends Thread {
        Point mousePoint;
        NhmCheckbox comp;

        public FlyOverTimer(NhmCheckbox nhmCheckbox, Point point) {
            NhmPanel.this = NhmPanel.this;
            this.comp = nhmCheckbox;
            this.mousePoint = point;
            this.setPriority(this.getPriority() - 1);
        }

        public void run() {
            try {
                Thread.sleep(NhmPanel.this.access$0());
                Point point = this.comp.getLocationOnScreen();
                Point point2 = new Point(point.x + 5, point.y + this.mousePoint.y);
                this.setPriority(10);
                NhmPanel.this.access$1(this.comp.getFlyOverText(), point2);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

